package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.Salesbill;
import com.xforceplus.ultraman.app.jchuazhu.service.ISalesbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-02
 */
@RestController
public class SalesbillController {

  @Autowired
  private ISalesbillService salesbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesbill ${table.comment}
   * @return
   */
  @GetMapping("/salesbills" )
  public XfR getSalesbills(XfPage page, Salesbill salesbill) {
    return XfR.ok(salesbillServiceImpl.page(page, Wrappers.query(salesbill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesbillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesbill ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesbills")
  public XfR save(@RequestBody Salesbill salesbill) {
     return XfR.ok(salesbillServiceImpl.save(salesbill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesbill ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesbills/{id}")
  public XfR putUpdate(@RequestBody Salesbill salesbill,@PathVariable Long id) {
      salesbill.setId(id);
      return XfR.ok(salesbillServiceImpl.updateById(salesbill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesbill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesbills/{id}")
  public XfR patchUpdate(@RequestBody Salesbill salesbill,@PathVariable Long id) {
      Salesbill upsalesbill = salesbillServiceImpl.getById(id);
      if(upsalesbill != null){
        upsalesbill = ObjectCopyUtils.copyProperties(salesbill,upsalesbill,true);
      }
      return XfR.ok(salesbillServiceImpl.updateById(upsalesbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesbillServiceImpl.removeById(id));
  }

  @PostMapping("/salesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "salesbill");
     params.put("request", condition);

     return XfR.ok(salesbillServiceImpl.querys(params));
  }

}
