package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.BasicInfo;
import com.xforceplus.ultraman.app.jchuazhu.service.IBasicInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-05
 */
@RestController
public class BasicInfoController {

  @Autowired
  private IBasicInfoService basicInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param basicInfo ${table.comment}
   * @return
   */
  @GetMapping("/basicinfos" )
  public XfR getBasicInfos(XfPage page, BasicInfo basicInfo) {
    return XfR.ok(basicInfoServiceImpl.page(page, Wrappers.query(basicInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basicinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(basicInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param basicInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/basicinfos")
  public XfR save(@RequestBody BasicInfo basicInfo) {
     return XfR.ok(basicInfoServiceImpl.save(basicInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param basicInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/basicinfos/{id}")
  public XfR putUpdate(@RequestBody BasicInfo basicInfo,@PathVariable Long id) {
      basicInfo.setId(id);
      return XfR.ok(basicInfoServiceImpl.updateById(basicInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param basicInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basicinfos/{id}")
  public XfR patchUpdate(@RequestBody BasicInfo basicInfo,@PathVariable Long id) {
      BasicInfo upbasicInfo = basicInfoServiceImpl.getById(id);
      if(upbasicInfo != null){
        upbasicInfo = ObjectCopyUtils.copyProperties(basicInfo,upbasicInfo,true);
      }
      return XfR.ok(basicInfoServiceImpl.updateById(upbasicInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basicinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(basicInfoServiceImpl.removeById(id));
  }

  @PostMapping("/basicinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "basic_info");
     params.put("request", condition);

     return XfR.ok(basicInfoServiceImpl.querys(params));
  }

}
