package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.EmpHotelRelation;
import com.xforceplus.ultraman.app.jchuazhu.service.IEmpHotelRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-05
 */
@RestController
public class EmpHotelRelationController {

  @Autowired
  private IEmpHotelRelationService empHotelRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param empHotelRelation ${table.comment}
   * @return
   */
  @GetMapping("/emphotelrelations" )
  public XfR getEmpHotelRelations(XfPage page, EmpHotelRelation empHotelRelation) {
    return XfR.ok(empHotelRelationServiceImpl.page(page, Wrappers.query(empHotelRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/emphotelrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(empHotelRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param empHotelRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/emphotelrelations")
  public XfR save(@RequestBody EmpHotelRelation empHotelRelation) {
     return XfR.ok(empHotelRelationServiceImpl.save(empHotelRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param empHotelRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/emphotelrelations/{id}")
  public XfR putUpdate(@RequestBody EmpHotelRelation empHotelRelation,@PathVariable Long id) {
      empHotelRelation.setId(id);
      return XfR.ok(empHotelRelationServiceImpl.updateById(empHotelRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param empHotelRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/emphotelrelations/{id}")
  public XfR patchUpdate(@RequestBody EmpHotelRelation empHotelRelation,@PathVariable Long id) {
      EmpHotelRelation upempHotelRelation = empHotelRelationServiceImpl.getById(id);
      if(upempHotelRelation != null){
        upempHotelRelation = ObjectCopyUtils.copyProperties(empHotelRelation,upempHotelRelation,true);
      }
      return XfR.ok(empHotelRelationServiceImpl.updateById(upempHotelRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/emphotelrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(empHotelRelationServiceImpl.removeById(id));
  }

  @PostMapping("/emphotelrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "emp_hotel_relation");
     params.put("request", condition);

     return XfR.ok(empHotelRelationServiceImpl.querys(params));
  }

}
