package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MasterDataPushInterface;
import com.xforceplus.ultraman.app.jchuazhu.service.IMasterDataPushInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-05
 */
@RestController
public class MasterDataPushInterfaceController {

  @Autowired
  private IMasterDataPushInterfaceService masterDataPushInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param masterDataPushInterface ${table.comment}
   * @return
   */
  @GetMapping("/masterdatapushinterfaces" )
  public XfR getMasterDataPushInterfaces(XfPage page, MasterDataPushInterface masterDataPushInterface) {
    return XfR.ok(masterDataPushInterfaceServiceImpl.page(page, Wrappers.query(masterDataPushInterface)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/masterdatapushinterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(masterDataPushInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param masterDataPushInterface ${table.comment}
   * @return XfR
   */
  @PostMapping("/masterdatapushinterfaces")
  public XfR save(@RequestBody MasterDataPushInterface masterDataPushInterface) {
     return XfR.ok(masterDataPushInterfaceServiceImpl.save(masterDataPushInterface));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param masterDataPushInterface ${table.comment}
   * @return XfR
   */
  @PutMapping("/masterdatapushinterfaces/{id}")
  public XfR putUpdate(@RequestBody MasterDataPushInterface masterDataPushInterface,@PathVariable Long id) {
      masterDataPushInterface.setId(id);
      return XfR.ok(masterDataPushInterfaceServiceImpl.updateById(masterDataPushInterface));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param masterDataPushInterface ${table.comment}
   * @return XfR
   */
  @PatchMapping("/masterdatapushinterfaces/{id}")
  public XfR patchUpdate(@RequestBody MasterDataPushInterface masterDataPushInterface,@PathVariable Long id) {
      MasterDataPushInterface upmasterDataPushInterface = masterDataPushInterfaceServiceImpl.getById(id);
      if(upmasterDataPushInterface != null){
        upmasterDataPushInterface = ObjectCopyUtils.copyProperties(masterDataPushInterface,upmasterDataPushInterface,true);
      }
      return XfR.ok(masterDataPushInterfaceServiceImpl.updateById(upmasterDataPushInterface));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/masterdatapushinterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(masterDataPushInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/masterdatapushinterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "master_data_push_interface");
     params.put("request", condition);

     return XfR.ok(masterDataPushInterfaceServiceImpl.querys(params));
  }

}
