package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.DeductionVoucher;
import com.xforceplus.ultraman.app.jchuazhu.service.IDeductionVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-02
 */
@RestController
public class DeductionVoucherController {

  @Autowired
  private IDeductionVoucherService deductionVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deductionVoucher ${table.comment}
   * @return
   */
  @GetMapping("/deductionvouchers" )
  public XfR getDeductionVouchers(XfPage page, DeductionVoucher deductionVoucher) {
    return XfR.ok(deductionVoucherServiceImpl.page(page, Wrappers.query(deductionVoucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deductionvouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deductionVoucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deductionVoucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/deductionvouchers")
  public XfR save(@RequestBody DeductionVoucher deductionVoucher) {
     return XfR.ok(deductionVoucherServiceImpl.save(deductionVoucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deductionVoucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/deductionvouchers/{id}")
  public XfR putUpdate(@RequestBody DeductionVoucher deductionVoucher,@PathVariable Long id) {
      deductionVoucher.setId(id);
      return XfR.ok(deductionVoucherServiceImpl.updateById(deductionVoucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deductionVoucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deductionvouchers/{id}")
  public XfR patchUpdate(@RequestBody DeductionVoucher deductionVoucher,@PathVariable Long id) {
      DeductionVoucher updeductionVoucher = deductionVoucherServiceImpl.getById(id);
      if(updeductionVoucher != null){
        updeductionVoucher = ObjectCopyUtils.copyProperties(deductionVoucher,updeductionVoucher,true);
      }
      return XfR.ok(deductionVoucherServiceImpl.updateById(updeductionVoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deductionvouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deductionVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/deductionvouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deduction_voucher");
     params.put("request", condition);

     return XfR.ok(deductionVoucherServiceImpl.querys(params));
  }

}
