package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.InterfaceLog;
import com.xforceplus.ultraman.app.jchuazhu.service.IInterfaceLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-02
 */
@RestController
public class InterfaceLogController {

  @Autowired
  private IInterfaceLogService interfaceLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param interfaceLog ${table.comment}
   * @return
   */
  @GetMapping("/interfacelogs" )
  public XfR getInterfaceLogs(XfPage page, InterfaceLog interfaceLog) {
    return XfR.ok(interfaceLogServiceImpl.page(page, Wrappers.query(interfaceLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/interfacelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(interfaceLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param interfaceLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/interfacelogs")
  public XfR save(@RequestBody InterfaceLog interfaceLog) {
     return XfR.ok(interfaceLogServiceImpl.save(interfaceLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param interfaceLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/interfacelogs/{id}")
  public XfR putUpdate(@RequestBody InterfaceLog interfaceLog,@PathVariable Long id) {
      interfaceLog.setId(id);
      return XfR.ok(interfaceLogServiceImpl.updateById(interfaceLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param interfaceLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/interfacelogs/{id}")
  public XfR patchUpdate(@RequestBody InterfaceLog interfaceLog,@PathVariable Long id) {
      InterfaceLog upinterfaceLog = interfaceLogServiceImpl.getById(id);
      if(upinterfaceLog != null){
        upinterfaceLog = ObjectCopyUtils.copyProperties(interfaceLog,upinterfaceLog,true);
      }
      return XfR.ok(interfaceLogServiceImpl.updateById(upinterfaceLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/interfacelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(interfaceLogServiceImpl.removeById(id));
  }

  @PostMapping("/interfacelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "interface_log");
     params.put("request", condition);

     return XfR.ok(interfaceLogServiceImpl.querys(params));
  }

}
