package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MerchantCompanyRelation;
import com.xforceplus.ultraman.app.jchuazhu.service.IMerchantCompanyRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-02
 */
@RestController
public class MerchantCompanyRelationController {

  @Autowired
  private IMerchantCompanyRelationService merchantCompanyRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param merchantCompanyRelation ${table.comment}
   * @return
   */
  @GetMapping("/merchantcompanyrelations" )
  public XfR getMerchantCompanyRelations(XfPage page, MerchantCompanyRelation merchantCompanyRelation) {
    return XfR.ok(merchantCompanyRelationServiceImpl.page(page, Wrappers.query(merchantCompanyRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/merchantcompanyrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(merchantCompanyRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param merchantCompanyRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/merchantcompanyrelations")
  public XfR save(@RequestBody MerchantCompanyRelation merchantCompanyRelation) {
     return XfR.ok(merchantCompanyRelationServiceImpl.save(merchantCompanyRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param merchantCompanyRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/merchantcompanyrelations/{id}")
  public XfR putUpdate(@RequestBody MerchantCompanyRelation merchantCompanyRelation,@PathVariable Long id) {
      merchantCompanyRelation.setId(id);
      return XfR.ok(merchantCompanyRelationServiceImpl.updateById(merchantCompanyRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param merchantCompanyRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/merchantcompanyrelations/{id}")
  public XfR patchUpdate(@RequestBody MerchantCompanyRelation merchantCompanyRelation,@PathVariable Long id) {
      MerchantCompanyRelation upmerchantCompanyRelation = merchantCompanyRelationServiceImpl.getById(id);
      if(upmerchantCompanyRelation != null){
        upmerchantCompanyRelation = ObjectCopyUtils.copyProperties(merchantCompanyRelation,upmerchantCompanyRelation,true);
      }
      return XfR.ok(merchantCompanyRelationServiceImpl.updateById(upmerchantCompanyRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/merchantcompanyrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(merchantCompanyRelationServiceImpl.removeById(id));
  }

  @PostMapping("/merchantcompanyrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "merchant_company_relation");
     params.put("request", condition);

     return XfR.ok(merchantCompanyRelationServiceImpl.querys(params));
  }

}
