package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.OfflineInvoice;
import com.xforceplus.ultraman.app.jchuazhu.service.IOfflineInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-02
 */
@RestController
public class OfflineInvoiceController {

  @Autowired
  private IOfflineInvoiceService offlineInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param offlineInvoice ${table.comment}
   * @return
   */
  @GetMapping("/offlineinvoices" )
  public XfR getOfflineInvoices(XfPage page, OfflineInvoice offlineInvoice) {
    return XfR.ok(offlineInvoiceServiceImpl.page(page, Wrappers.query(offlineInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/offlineinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(offlineInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param offlineInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/offlineinvoices")
  public XfR save(@RequestBody OfflineInvoice offlineInvoice) {
     return XfR.ok(offlineInvoiceServiceImpl.save(offlineInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param offlineInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/offlineinvoices/{id}")
  public XfR putUpdate(@RequestBody OfflineInvoice offlineInvoice,@PathVariable Long id) {
      offlineInvoice.setId(id);
      return XfR.ok(offlineInvoiceServiceImpl.updateById(offlineInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param offlineInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/offlineinvoices/{id}")
  public XfR patchUpdate(@RequestBody OfflineInvoice offlineInvoice,@PathVariable Long id) {
      OfflineInvoice upofflineInvoice = offlineInvoiceServiceImpl.getById(id);
      if(upofflineInvoice != null){
        upofflineInvoice = ObjectCopyUtils.copyProperties(offlineInvoice,upofflineInvoice,true);
      }
      return XfR.ok(offlineInvoiceServiceImpl.updateById(upofflineInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/offlineinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(offlineInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/offlineinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "offline_invoice");
     params.put("request", condition);

     return XfR.ok(offlineInvoiceServiceImpl.querys(params));
  }

}
