package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.ScheduledTaskExec;
import com.xforceplus.ultraman.app.jchuazhu.service.IScheduledTaskExecService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-02
 */
@RestController
public class ScheduledTaskExecController {

  @Autowired
  private IScheduledTaskExecService scheduledTaskExecServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param scheduledTaskExec ${table.comment}
   * @return
   */
  @GetMapping("/scheduledtaskexecs" )
  public XfR getScheduledTaskExecs(XfPage page, ScheduledTaskExec scheduledTaskExec) {
    return XfR.ok(scheduledTaskExecServiceImpl.page(page, Wrappers.query(scheduledTaskExec)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/scheduledtaskexecs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(scheduledTaskExecServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param scheduledTaskExec ${table.comment}
   * @return XfR
   */
  @PostMapping("/scheduledtaskexecs")
  public XfR save(@RequestBody ScheduledTaskExec scheduledTaskExec) {
     return XfR.ok(scheduledTaskExecServiceImpl.save(scheduledTaskExec));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param scheduledTaskExec ${table.comment}
   * @return XfR
   */
  @PutMapping("/scheduledtaskexecs/{id}")
  public XfR putUpdate(@RequestBody ScheduledTaskExec scheduledTaskExec,@PathVariable Long id) {
      scheduledTaskExec.setId(id);
      return XfR.ok(scheduledTaskExecServiceImpl.updateById(scheduledTaskExec));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param scheduledTaskExec ${table.comment}
   * @return XfR
   */
  @PatchMapping("/scheduledtaskexecs/{id}")
  public XfR patchUpdate(@RequestBody ScheduledTaskExec scheduledTaskExec,@PathVariable Long id) {
      ScheduledTaskExec upscheduledTaskExec = scheduledTaskExecServiceImpl.getById(id);
      if(upscheduledTaskExec != null){
        upscheduledTaskExec = ObjectCopyUtils.copyProperties(scheduledTaskExec,upscheduledTaskExec,true);
      }
      return XfR.ok(scheduledTaskExecServiceImpl.updateById(upscheduledTaskExec));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/scheduledtaskexecs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(scheduledTaskExecServiceImpl.removeById(id));
  }

  @PostMapping("/scheduledtaskexecs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "scheduled_task_exec");
     params.put("request", condition);

     return XfR.ok(scheduledTaskExecServiceImpl.querys(params));
  }

}
