package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.AuditInvoiceDto;
import com.xforceplus.ultraman.app.jchuazhu.service.IAuditInvoiceDtoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-27
 */
@RestController
public class AuditInvoiceDtoController {

  @Autowired
  private IAuditInvoiceDtoService auditInvoiceDtoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param auditInvoiceDto ${table.comment}
   * @return
   */
  @GetMapping("/auditinvoicedtos" )
  public XfR getAuditInvoiceDtos(XfPage page, AuditInvoiceDto auditInvoiceDto) {
    return XfR.ok(auditInvoiceDtoServiceImpl.page(page, Wrappers.query(auditInvoiceDto)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/auditinvoicedtos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(auditInvoiceDtoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param auditInvoiceDto ${table.comment}
   * @return XfR
   */
  @PostMapping("/auditinvoicedtos")
  public XfR save(@RequestBody AuditInvoiceDto auditInvoiceDto) {
     return XfR.ok(auditInvoiceDtoServiceImpl.save(auditInvoiceDto));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param auditInvoiceDto ${table.comment}
   * @return XfR
   */
  @PutMapping("/auditinvoicedtos/{id}")
  public XfR putUpdate(@RequestBody AuditInvoiceDto auditInvoiceDto,@PathVariable Long id) {
      auditInvoiceDto.setId(id);
      return XfR.ok(auditInvoiceDtoServiceImpl.updateById(auditInvoiceDto));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param auditInvoiceDto ${table.comment}
   * @return XfR
   */
  @PatchMapping("/auditinvoicedtos/{id}")
  public XfR patchUpdate(@RequestBody AuditInvoiceDto auditInvoiceDto,@PathVariable Long id) {
      AuditInvoiceDto upauditInvoiceDto = auditInvoiceDtoServiceImpl.getById(id);
      if(upauditInvoiceDto != null){
        upauditInvoiceDto = ObjectCopyUtils.copyProperties(auditInvoiceDto,upauditInvoiceDto,true);
      }
      return XfR.ok(auditInvoiceDtoServiceImpl.updateById(upauditInvoiceDto));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/auditinvoicedtos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(auditInvoiceDtoServiceImpl.removeById(id));
  }

  @PostMapping("/auditinvoicedtos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "audit_invoice_dto");
     params.put("request", condition);

     return XfR.ok(auditInvoiceDtoServiceImpl.querys(params));
  }

}
