package com.xforceplus.ultraman.app.jchuazhu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jchuazhu.entity.MasterDataInterface;
import com.xforceplus.ultraman.app.jchuazhu.service.IMasterDataInterfaceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 前端控制器
 *
 * @author ultraman
 * @date 2022-10-27
 */
@RestController
public class MasterDataInterfaceController {

  @Autowired
  private IMasterDataInterfaceService masterDataInterfaceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param masterDataInterface 
   * @return
   */
  @GetMapping("/masterdatainterfaces" )
  public XfR getMasterDataInterfaces(XfPage page, MasterDataInterface masterDataInterface) {
    return XfR.ok(masterDataInterfaceServiceImpl.page(page, Wrappers.query(masterDataInterface)));
  }

  /**
   * 通过id查询
   * @param  id
   * @return XfR
   */
  @GetMapping("/masterdatainterfaces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(masterDataInterfaceServiceImpl.getById(id));
  }

  /**
   * 新增
   * @param masterDataInterface 
   * @return XfR
   */
  @PostMapping("/masterdatainterfaces")
  public XfR save(@RequestBody MasterDataInterface masterDataInterface) {
     return XfR.ok(masterDataInterfaceServiceImpl.save(masterDataInterface));
  }

  /**
   * 修改-传入修改后的全部数据
   * @param masterDataInterface 
   * @return XfR
   */
  @PutMapping("/masterdatainterfaces/{id}")
  public XfR putUpdate(@RequestBody MasterDataInterface masterDataInterface,@PathVariable Long id) {
      masterDataInterface.setId(id);
      return XfR.ok(masterDataInterfaceServiceImpl.updateById(masterDataInterface));
  }

  /**
   * 修改-传入修改的数据
   * @param masterDataInterface 
   * @return XfR
   */
  @PatchMapping("/masterdatainterfaces/{id}")
  public XfR patchUpdate(@RequestBody MasterDataInterface masterDataInterface,@PathVariable Long id) {
      MasterDataInterface upmasterDataInterface = masterDataInterfaceServiceImpl.getById(id);
      if(upmasterDataInterface != null){
        upmasterDataInterface = ObjectCopyUtils.copyProperties(masterDataInterface,upmasterDataInterface,true);
      }
      return XfR.ok(masterDataInterfaceServiceImpl.updateById(upmasterDataInterface));
  }

  /**
   * 通过id删除
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/masterdatainterfaces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(masterDataInterfaceServiceImpl.removeById(id));
  }

  @PostMapping("/masterdatainterfaces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "master_data_interface");
     params.put("request", condition);

     return XfR.ok(masterDataInterfaceServiceImpl.querys(params));
  }

}
