package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2022-01-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ImportCount;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-invoice-ikea")
public interface ImportCountFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/importCount/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param importCount ${table.comment}
   * @return R
   */
  @PostMapping("/importCount/add")
  public R save(@RequestBody ImportCount importCount);

  /**
   * 修改${table.comment}
   * @param importCount ${table.comment}
   * @return R
   */
  @PostMapping("/importCount/update")
  public R updateById(@RequestBody ImportCount importCount);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/importCount/del/{id}" )
  public R removeById(@PathVariable Long id);

}