package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


/**
 * 导入结果主信息feign客户端
 *
 * @author ultraman
 * @date 2022-01-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ImportResultHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-invoice-ikea")
public interface ImportResultHeadFeignApi {

  /**
   * 通过id查询导入结果主信息
   * @param  id
   * @return R
   */
  @GetMapping("/importResultHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增导入结果主信息
   * @param importResultHead 导入结果主信息
   * @return R
   */
  @PostMapping("/importResultHead/add")
  public R save(@RequestBody ImportResultHead importResultHead);

  /**
   * 修改导入结果主信息
   * @param importResultHead 导入结果主信息
   * @return R
   */
  @PostMapping("/importResultHead/update")
  public R updateById(@RequestBody ImportResultHead importResultHead);

  /**
   * 通过id删除导入结果主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/importResultHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}