package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


/**
 * 发票类型匹配配置feign客户端
 *
 * @author ultraman
 * @date 2022-01-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.InvoiceSetting;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-invoice-ikea")
public interface InvoiceSettingFeignApi {

  /**
   * 通过id查询发票类型匹配配置
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceSetting/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票类型匹配配置
   * @param invoiceSetting 发票类型匹配配置
   * @return R
   */
  @PostMapping("/invoiceSetting/add")
  public R save(@RequestBody InvoiceSetting invoiceSetting);

  /**
   * 修改发票类型匹配配置
   * @param invoiceSetting 发票类型匹配配置
   * @return R
   */
  @PostMapping("/invoiceSetting/update")
  public R updateById(@RequestBody InvoiceSetting invoiceSetting);

  /**
   * 通过id删除发票类型匹配配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceSetting/del/{id}" )
  public R removeById(@PathVariable Long id);

}