package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


/**
 * 上传OSS的电票源文件信息feign客户端
 *
 * @author ultraman
 * @date 2022-01-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.UploadFileToOss;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-invoice-ikea")
public interface UploadFileToOssFeignApi {

  /**
   * 通过id查询上传OSS的电票源文件信息
   * @param  id
   * @return R
   */
  @GetMapping("/uploadFileToOss/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增上传OSS的电票源文件信息
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return R
   */
  @PostMapping("/uploadFileToOss/add")
  public R save(@RequestBody UploadFileToOss uploadFileToOss);

  /**
   * 修改上传OSS的电票源文件信息
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return R
   */
  @PostMapping("/uploadFileToOss/update")
  public R updateById(@RequestBody UploadFileToOss uploadFileToOss);

  /**
   * 通过id删除上传OSS的电票源文件信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/uploadFileToOss/del/{id}" )
  public R removeById(@PathVariable Long id);

}