package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单同步状态
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
public enum BillSynchronousStatus {

    _0("0", "同步结果待反馈"),
    _1("1", "成功"),
    _2("2", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BillSynchronousStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillSynchronousStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
