package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入状态
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
public enum ImportStatus {

    _0("0", "导入失败"),
    _1("1", "导入成功"),
    _2("2", "导入中"),
    _3("3", "部分成功"),
    _4("4", "准备处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImportStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
