package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * comp_sales_record
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompSalesRecord implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * Whs
   */
  private String whs;
  /**
   * Order Tp
   */
  private String orderTp;
  /**
   * Country
   */
  private String country;
  /**
   * Cust
   */
  private String cust;
  /**
   * Cust Nm
   */
  private String custNm;
  /**
   * Order No
   */
  private String orderNo;
  /**
   * Inv No
   */
  private String invNo;
  /**
   * Item No
   */
  private String itemNo;
  /**
   * Item name
   */
  private String itemName;
  /**
   * Item name (CN)
   */
  private String itemNameCn;
  /**
   * Unit
   */
  private String unit;
  /**
   * Price
   */
  private String price;
  /**
   * Inv Amount
   */
  private String invAmount;
  /**
   * Inv Amt(VAT)
   */
  private String invAmtVAT;
  /**
   * Currency
   */
  private String currency;
  /**
   * Exchange rate
   */
  private String exchangeRate;
  /**
   * Inv Dt
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invDt;
  /**
   * Inv Sts
   */
  private String invSts;
  /**
   * Dely Qty
   */
  private String delyQty;
  /**
   * Dely Dt
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime delyDt;
  /**
   * LineTp
   */
  private String lineTp;
  /**
   * Customers order number
   */
  private String customersOrderNumber;
  /**
   * Note
   */
  private String note;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * Inv Qty
   */
  private BigDecimal invQty;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("whs", whs);
      map.put("orderTp", orderTp);
      map.put("country", country);
      map.put("cust", cust);
      map.put("custNm", custNm);
      map.put("orderNo", orderNo);
      map.put("invNo", invNo);
      map.put("itemNo", itemNo);
      map.put("itemName", itemName);
      map.put("itemNameCn", itemNameCn);
      map.put("unit", unit);
      map.put("price", price);
      map.put("invAmount", invAmount);
      map.put("invAmtVAT", invAmtVAT);
      map.put("currency", currency);
      map.put("exchangeRate", exchangeRate);
      map.put("invDt", BocpGenUtils.toTimestamp(invDt));
      map.put("invSts", invSts);
      map.put("delyQty", delyQty);
      map.put("delyDt", BocpGenUtils.toTimestamp(delyDt));
      map.put("lineTp", lineTp);
      map.put("customersOrderNumber", customersOrderNumber);
      map.put("note", note);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invQty", invQty);

      return map;
  }

  public static CompSalesRecord fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompSalesRecord entity = new CompSalesRecord();

    if(map.containsKey("whs")) {
      Object obj = map.get("whs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWhs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTp")) {
      Object obj = map.get("orderTp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust")) {
      Object obj = map.get("cust");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCust((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custNm")) {
      Object obj = map.get("custNm");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustNm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invNo")) {
      Object obj = map.get("invNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNameCn")) {
      Object obj = map.get("itemNameCn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNameCn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmount")) {
      Object obj = map.get("invAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmtVAT")) {
      Object obj = map.get("invAmtVAT");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvAmtVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchangeRate")) {
      Object obj = map.get("exchangeRate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExchangeRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invDt")) {
      Object obj = map.get("invDt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvDt(null);
      }
    }
    if(map.containsKey("invSts")) {
      Object obj = map.get("invSts");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvSts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyQty")) {
      Object obj = map.get("delyQty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDelyQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyDt")) {
      Object obj = map.get("delyDt");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDelyDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDelyDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDelyDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDelyDt(null);
      }
    }
    if(map.containsKey("lineTp")) {
      Object obj = map.get("lineTp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customersOrderNumber")) {
      Object obj = map.get("customersOrderNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomersOrderNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("note")) {
      Object obj = map.get("note");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invQty")) {
      Object obj = map.get("invQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("whs")) {
      Object obj = map.get("whs");
      if(obj != null) {
        if(obj instanceof String){
            this.setWhs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTp")) {
      Object obj = map.get("orderTp");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String){
            this.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cust")) {
      Object obj = map.get("cust");
      if(obj != null) {
        if(obj instanceof String){
            this.setCust((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custNm")) {
      Object obj = map.get("custNm");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustNm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invNo")) {
      Object obj = map.get("invNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNameCn")) {
      Object obj = map.get("itemNameCn");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNameCn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof String){
            this.setPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmount")) {
      Object obj = map.get("invAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invAmtVAT")) {
      Object obj = map.get("invAmtVAT");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvAmtVAT((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exchangeRate")) {
      Object obj = map.get("exchangeRate");
      if(obj != null) {
        if(obj instanceof String){
            this.setExchangeRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invDt")) {
      Object obj = map.get("invDt");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setInvDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvDt(null);
      }
    }
    if(map.containsKey("invSts")) {
      Object obj = map.get("invSts");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvSts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyQty")) {
      Object obj = map.get("delyQty");
      if(obj != null) {
        if(obj instanceof String){
            this.setDelyQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delyDt")) {
      Object obj = map.get("delyDt");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDelyDt(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDelyDt((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setDelyDt(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDelyDt(null);
      }
    }
    if(map.containsKey("lineTp")) {
      Object obj = map.get("lineTp");
      if(obj != null) {
        if(obj instanceof String){
            this.setLineTp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customersOrderNumber")) {
      Object obj = map.get("customersOrderNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomersOrderNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("note")) {
      Object obj = map.get("note");
      if(obj != null) {
        if(obj instanceof String){
            this.setNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invQty")) {
      Object obj = map.get("invQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setInvQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setInvQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setInvQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setInvQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setInvQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
  }
}
