package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * export_purchase
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExportPurchase implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 关联号
   */
  private String associationNo;
  /**
   * 序号
   */
  private Long serialNo;
  /**
   * ContainerNo.
   */
  private String containerNo;
  /**
   * CSMNo.
   */
  private String csmNo;
  /**
   * 海关编号
   */
  private String customsNo;
  /**
   * 项号
   */
  private String itemNo;
  /**
   * 报关单号（公式）
   */
  private String customsDeclarationNo;
  /**
   * 商品名称
   */
  private String itemName;
  /**
   * 单位
   */
  private String quantityUnit;
  /**
   * 出口日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime departureDate;
  /**
   * 核销单号
   */
  private BigDecimal verificationNo;
  /**
   * 人民币离岸价
   */
  private String rmbFob;
  /**
   * 商品代码
   */
  private String itemCode;
  /**
   * 数量
   */
  private BigDecimal quantity;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 进货凭证号（发票代码+发票号码）
   */
  private String purchaseVoucherNo;
  /**
   * 发票开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime originDate;
  /**
   * 计税金额
   */
  private String amountWithTax;
  /**
   * 税额
   */
  private String tax;
  /**
   * 价税合计
   */
  private String priceWithTax;
  /**
   * Purchaserate
   */
  private BigDecimal purchaseRate;
  /**
   * 换汇成本
   */
  private BigDecimal unitExportCost;
  /**
   * 退税率
   */
  private BigDecimal taxRefundRate;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("associationNo", associationNo);
      map.put("serialNo", serialNo);
      map.put("containerNo", containerNo);
      map.put("csmNo", csmNo);
      map.put("customsNo", customsNo);
      map.put("itemNo", itemNo);
      map.put("customsDeclarationNo", customsDeclarationNo);
      map.put("itemName", itemName);
      map.put("quantityUnit", quantityUnit);
      map.put("departureDate", BocpGenUtils.toTimestamp(departureDate));
      map.put("verificationNo", verificationNo);
      map.put("rmbFob", rmbFob);
      map.put("itemCode", itemCode);
      map.put("quantity", quantity);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("purchaseVoucherNo", purchaseVoucherNo);
      map.put("originDate", BocpGenUtils.toTimestamp(originDate));
      map.put("amountWithTax", amountWithTax);
      map.put("tax", tax);
      map.put("priceWithTax", priceWithTax);
      map.put("purchaseRate", purchaseRate);
      map.put("unitExportCost", unitExportCost);
      map.put("taxRefundRate", taxRefundRate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ExportPurchase fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExportPurchase entity = new ExportPurchase();

    if(map.containsKey("associationNo")) {
      Object obj = map.get("associationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAssociationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSerialNo((Long)obj);
        } else if(obj instanceof String) {
          entity.setSerialNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSerialNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("containerNo")) {
      Object obj = map.get("containerNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContainerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("csmNo")) {
      Object obj = map.get("csmNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCsmNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customsNo")) {
      Object obj = map.get("customsNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customsDeclarationNo")) {
      Object obj = map.get("customsDeclarationNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomsDeclarationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departureDate")) {
      Object obj = map.get("departureDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDepartureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDepartureDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDepartureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDepartureDate(null);
      }
    }
    if(map.containsKey("verificationNo")) {
      Object obj = map.get("verificationNo");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVerificationNo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVerificationNo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVerificationNo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setVerificationNo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerificationNo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rmbFob")) {
      Object obj = map.get("rmbFob");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRmbFob((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseVoucherNo")) {
      Object obj = map.get("purchaseVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDate")) {
      Object obj = map.get("originDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOriginDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOriginDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOriginDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOriginDate(null);
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceWithTax")) {
      Object obj = map.get("priceWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRate")) {
      Object obj = map.get("purchaseRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPurchaseRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitExportCost")) {
      Object obj = map.get("unitExportCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitExportCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitExportCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitExportCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitExportCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitExportCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRefundRate")) {
      Object obj = map.get("taxRefundRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRefundRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRefundRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRefundRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRefundRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRefundRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("associationNo")) {
      Object obj = map.get("associationNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setAssociationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSerialNo((Long)obj);
        } else if(obj instanceof String) {
            this.setSerialNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSerialNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("containerNo")) {
      Object obj = map.get("containerNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setContainerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("csmNo")) {
      Object obj = map.get("csmNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setCsmNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customsNo")) {
      Object obj = map.get("customsNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customsDeclarationNo")) {
      Object obj = map.get("customsDeclarationNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustomsDeclarationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantityUnit")) {
      Object obj = map.get("quantityUnit");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("departureDate")) {
      Object obj = map.get("departureDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDepartureDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDepartureDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setDepartureDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDepartureDate(null);
      }
    }
    if(map.containsKey("verificationNo")) {
      Object obj = map.get("verificationNo");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setVerificationNo((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setVerificationNo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setVerificationNo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setVerificationNo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setVerificationNo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rmbFob")) {
      Object obj = map.get("rmbFob");
      if(obj != null) {
        if(obj instanceof String){
            this.setRmbFob((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseVoucherNo")) {
      Object obj = map.get("purchaseVoucherNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaseVoucherNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDate")) {
      Object obj = map.get("originDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOriginDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOriginDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setOriginDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOriginDate(null);
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceWithTax")) {
      Object obj = map.get("priceWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setPriceWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRate")) {
      Object obj = map.get("purchaseRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setPurchaseRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setPurchaseRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setPurchaseRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setPurchaseRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setPurchaseRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitExportCost")) {
      Object obj = map.get("unitExportCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setUnitExportCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setUnitExportCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setUnitExportCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setUnitExportCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setUnitExportCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRefundRate")) {
      Object obj = map.get("taxRefundRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRefundRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRefundRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRefundRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRefundRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRefundRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
