package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * import_result_head
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ImportResultHead implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 业务单号
   */
  private String salesbillNo;
  /**
   * 处理反馈结果
   */
  private String processRemark;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 导入批次
   */
  private String batchNo;
  /**
   * 请求信息
   */
  private String requestBody;
  /**
   * 返回信息
   */
  private String responseBody;
  /**
   * 处理单据位置
   */
  private Long aliveBill;
  /**
   * 总单据数量
   */
  private Long billCount;
  /**
   * 返回状态码
   */
  private String responseCode;
  /**
   * 文件名
   */
  private String fileName;
  /**
   * 同步状态
   */
  private String syncStatus;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillNo", salesbillNo);
      map.put("processRemark", processRemark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("batchNo", batchNo);
      map.put("requestBody", requestBody);
      map.put("responseBody", responseBody);
      map.put("aliveBill", aliveBill);
      map.put("billCount", billCount);
      map.put("responseCode", responseCode);
      map.put("fileName", fileName);
      map.put("syncStatus", syncStatus);

      return map;
  }

  public static ImportResultHead fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ImportResultHead entity = new ImportResultHead();

    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestBody")) {
      Object obj = map.get("requestBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responseBody")) {
      Object obj = map.get("responseBody");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aliveBill")) {
      Object obj = map.get("aliveBill");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAliveBill((Long)obj);
        } else if(obj instanceof String) {
          entity.setAliveBill(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAliveBill(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billCount")) {
      Object obj = map.get("billCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("responseCode")) {
      Object obj = map.get("responseCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncStatus")) {
      Object obj = map.get("syncStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSyncStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("processRemark")) {
      Object obj = map.get("processRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setProcessRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("requestBody")) {
      Object obj = map.get("requestBody");
      if(obj != null) {
        if(obj instanceof String){
            this.setRequestBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("responseBody")) {
      Object obj = map.get("responseBody");
      if(obj != null) {
        if(obj instanceof String){
            this.setResponseBody((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aliveBill")) {
      Object obj = map.get("aliveBill");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAliveBill((Long)obj);
        } else if(obj instanceof String) {
            this.setAliveBill(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setAliveBill(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("billCount")) {
      Object obj = map.get("billCount");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBillCount((Long)obj);
        } else if(obj instanceof String) {
            this.setBillCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBillCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("responseCode")) {
      Object obj = map.get("responseCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setResponseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fileName")) {
      Object obj = map.get("fileName");
      if(obj != null) {
        if(obj instanceof String){
            this.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("syncStatus")) {
      Object obj = map.get("syncStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setSyncStatus((String)obj);
        }
      } else{
      }
    }
  }
}
