package com.xforceplus.ultraman.app.jcinvoiceikea.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * reconciliation_invoice_lines7700
 * </p>
 *
 * @author ultraman
 * @since 2022-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReconciliationInvoiceLines7700 implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * Item No
   */
  private String itemNo;
  /**
   * Supplier No
   */
  private String supplierNo;
  /**
   * Tax Rate
   */
  private BigDecimal taxRate;
  /**
   * Booking Document
   */
  private String bookingDocument;
  /**
   * Booking Doc No
   */
  private String bookingDocNo;
  /**
   * Book Year Period
   */
  private String bookYearPeriod;
  /**
   * Invoice Date
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;
  /**
   * Dispatch Date
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dispatchDate;
  /**
   * ICI No
   */
  private String iciNo;
  /**
   * Legal No
   */
  private String legalNo;
  /**
   * CNOR Type
   */
  private String cnorType;
  /**
   * CNOR Code
   */
  private String cnorCode;
  /**
   * CNOR Country
   */
  private String cnorCountry;
  /**
   * Buyer BU Type
   */
  private String buyerBUType;
  /**
   * Buyer BU Code
   */
  private String buyerBUCode;
  /**
   * Buyer BU Country
   */
  private String buyerBUCountry;
  /**
   * Original CNEE Type
   */
  private String originalCNEEType;
  /**
   * Original CNEE Code
   */
  private String originalCNEECode;
  /**
   * Original CNEE Country
   */
  private String originalCNEECountry;
  /**
   * Consignment No
   */
  private String consignmentNo;
  /**
   * Shipping No
   */
  private String shippingNo;
  /**
   * Load Unit ID
   */
  private String loadUnitID;
  /**
   * Bill of Loading
   */
  private String billofLoading;
  /**
   * Distribution Type
   */
  private String distributionType;
  /**
   * Cur Code
   */
  private String curCode;
  /**
   * Invoice Value
   */
  private String invoiceValue;
  /**
   * Net Value/Unit
   */
  private BigDecimal netValueUnit;
  /**
   * Volume/Unit
   */
  private BigDecimal volumeUnit;
  /**
   * Weight/Unit
   */
  private BigDecimal weightUnit;
  /**
   * Quantity
   */
  private Long quantity;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("itemNo", itemNo);
      map.put("supplierNo", supplierNo);
      map.put("taxRate", taxRate);
      map.put("bookingDocument", bookingDocument);
      map.put("bookingDocNo", bookingDocNo);
      map.put("bookYearPeriod", bookYearPeriod);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("dispatchDate", BocpGenUtils.toTimestamp(dispatchDate));
      map.put("iciNo", iciNo);
      map.put("legalNo", legalNo);
      map.put("cnorType", cnorType);
      map.put("cnorCode", cnorCode);
      map.put("cnorCountry", cnorCountry);
      map.put("buyerBUType", buyerBUType);
      map.put("buyerBUCode", buyerBUCode);
      map.put("buyerBUCountry", buyerBUCountry);
      map.put("originalCNEEType", originalCNEEType);
      map.put("originalCNEECode", originalCNEECode);
      map.put("originalCNEECountry", originalCNEECountry);
      map.put("consignmentNo", consignmentNo);
      map.put("shippingNo", shippingNo);
      map.put("loadUnitID", loadUnitID);
      map.put("billofLoading", billofLoading);
      map.put("distributionType", distributionType);
      map.put("curCode", curCode);
      map.put("invoiceValue", invoiceValue);
      map.put("netValueUnit", netValueUnit);
      map.put("volumeUnit", volumeUnit);
      map.put("weightUnit", weightUnit);
      map.put("quantity", quantity);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ReconciliationInvoiceLines7700 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReconciliationInvoiceLines7700 entity = new ReconciliationInvoiceLines7700();

    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierNo")) {
      Object obj = map.get("supplierNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bookingDocument")) {
      Object obj = map.get("bookingDocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingDocNo")) {
      Object obj = map.get("bookingDocNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookingDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookYearPeriod")) {
      Object obj = map.get("bookYearPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBookYearPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("dispatchDate")) {
      Object obj = map.get("dispatchDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDispatchDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDispatchDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDispatchDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDispatchDate(null);
      }
    }
    if(map.containsKey("iciNo")) {
      Object obj = map.get("iciNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIciNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legalNo")) {
      Object obj = map.get("legalNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLegalNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorType")) {
      Object obj = map.get("cnorType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCnorType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorCode")) {
      Object obj = map.get("cnorCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCnorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorCountry")) {
      Object obj = map.get("cnorCountry");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCnorCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUType")) {
      Object obj = map.get("buyerBUType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerBUType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUCode")) {
      Object obj = map.get("buyerBUCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerBUCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUCountry")) {
      Object obj = map.get("buyerBUCountry");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerBUCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEEType")) {
      Object obj = map.get("originalCNEEType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalCNEEType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEECode")) {
      Object obj = map.get("originalCNEECode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalCNEECode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEECountry")) {
      Object obj = map.get("originalCNEECountry");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalCNEECountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignmentNo")) {
      Object obj = map.get("consignmentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConsignmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNo")) {
      Object obj = map.get("shippingNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShippingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("loadUnitID")) {
      Object obj = map.get("loadUnitID");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoadUnitID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billofLoading")) {
      Object obj = map.get("billofLoading");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillofLoading((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionType")) {
      Object obj = map.get("distributionType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDistributionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curCode")) {
      Object obj = map.get("curCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceValue")) {
      Object obj = map.get("invoiceValue");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netValueUnit")) {
      Object obj = map.get("netValueUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetValueUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetValueUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetValueUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setNetValueUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetValueUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVolumeUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVolumeUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVolumeUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setVolumeUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVolumeUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("weightUnit")) {
      Object obj = map.get("weightUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setWeightUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setWeightUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setWeightUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setWeightUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWeightUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQuantity((Long)obj);
        } else if(obj instanceof String) {
          entity.setQuantity(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQuantity(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("itemNo")) {
      Object obj = map.get("itemNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierNo")) {
      Object obj = map.get("supplierNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSupplierNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bookingDocument")) {
      Object obj = map.get("bookingDocument");
      if(obj != null) {
        if(obj instanceof String){
            this.setBookingDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingDocNo")) {
      Object obj = map.get("bookingDocNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBookingDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookYearPeriod")) {
      Object obj = map.get("bookYearPeriod");
      if(obj != null) {
        if(obj instanceof String){
            this.setBookYearPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("dispatchDate")) {
      Object obj = map.get("dispatchDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setDispatchDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setDispatchDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setDispatchDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setDispatchDate(null);
      }
    }
    if(map.containsKey("iciNo")) {
      Object obj = map.get("iciNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setIciNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legalNo")) {
      Object obj = map.get("legalNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setLegalNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorType")) {
      Object obj = map.get("cnorType");
      if(obj != null) {
        if(obj instanceof String){
            this.setCnorType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorCode")) {
      Object obj = map.get("cnorCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCnorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cnorCountry")) {
      Object obj = map.get("cnorCountry");
      if(obj != null) {
        if(obj instanceof String){
            this.setCnorCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUType")) {
      Object obj = map.get("buyerBUType");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerBUType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUCode")) {
      Object obj = map.get("buyerBUCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerBUCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBUCountry")) {
      Object obj = map.get("buyerBUCountry");
      if(obj != null) {
        if(obj instanceof String){
            this.setBuyerBUCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEEType")) {
      Object obj = map.get("originalCNEEType");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginalCNEEType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEECode")) {
      Object obj = map.get("originalCNEECode");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginalCNEECode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalCNEECountry")) {
      Object obj = map.get("originalCNEECountry");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginalCNEECountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consignmentNo")) {
      Object obj = map.get("consignmentNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setConsignmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippingNo")) {
      Object obj = map.get("shippingNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setShippingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("loadUnitID")) {
      Object obj = map.get("loadUnitID");
      if(obj != null) {
        if(obj instanceof String){
            this.setLoadUnitID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billofLoading")) {
      Object obj = map.get("billofLoading");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillofLoading((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionType")) {
      Object obj = map.get("distributionType");
      if(obj != null) {
        if(obj instanceof String){
            this.setDistributionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("curCode")) {
      Object obj = map.get("curCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCurCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceValue")) {
      Object obj = map.get("invoiceValue");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netValueUnit")) {
      Object obj = map.get("netValueUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setNetValueUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setNetValueUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setNetValueUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setNetValueUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setNetValueUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setVolumeUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setVolumeUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setVolumeUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setVolumeUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setVolumeUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("weightUnit")) {
      Object obj = map.get("weightUnit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setWeightUnit((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setWeightUnit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setWeightUnit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setWeightUnit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setWeightUnit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setQuantity((Long)obj);
        } else if(obj instanceof String) {
            this.setQuantity(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setQuantity(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
  }
}
