package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.Eqb;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IEqbService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 2. EQB202105 72150110-72150138前端控制器
 *
 * @author ultraman
 * @date 2021-12-24
 */
@RestController
public class EqbController {

  @Autowired
  private IEqbService eqbServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param eqb 2. EQB202105 72150110-72150138
   * @return
   */
  @GetMapping("/eqbs" )
  public XfR getEqbs(XfPage page, Eqb eqb) {
    return XfR.ok(eqbServiceImpl.page(page, Wrappers.query(eqb)));
  }

  /**
   * 通过id查询2. EQB202105 72150110-72150138
   * @param  id
   * @return XfR
   */
  @GetMapping("/eqbs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(eqbServiceImpl.getById(id));
  }

  /**
   * 新增2. EQB202105 72150110-72150138
   * @param eqb 2. EQB202105 72150110-72150138
   * @return XfR
   */
  @PostMapping("/eqbs")
  public XfR save(@RequestBody Eqb eqb) {
     return XfR.ok(eqbServiceImpl.save(eqb));
  }

  /**
   * 修改-传入修改后的全部数据2. EQB202105 72150110-72150138
   * @param eqb 2. EQB202105 72150110-72150138
   * @return XfR
   */
  @PutMapping("/eqbs/{id}")
  public XfR putUpdate(@RequestBody Eqb eqb,@PathVariable Long id) {
      eqb.setId(id);
      return XfR.ok(eqbServiceImpl.updateById(eqb));
  }

  /**
   * 修改-传入修改的数据2. EQB202105 72150110-72150138
   * @param eqb 2. EQB202105 72150110-72150138
   * @return XfR
   */
  @PatchMapping("/eqbs/{id}")
  public XfR patchUpdate(@RequestBody Eqb eqb,@PathVariable Long id) {
      Eqb upeqb = eqbServiceImpl.getById(id);
      if(upeqb != null){
        upeqb = ObjectCopyUtils.copyProperties(eqb,upeqb,true);
      }
      return XfR.ok(eqbServiceImpl.updateById(upeqb));
  }

  /**
   * 通过id删除2. EQB202105 72150110-72150138
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/eqbs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(eqbServiceImpl.removeById(id));
  }

  @PostMapping("/eqbs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "eqb");
     params.put("request", condition);

     return XfR.ok(eqbServiceImpl.querys(params));
  }

}
