package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ReconciliationInvoiceLines;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IReconciliationInvoiceLinesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 4992 Reconciliation Invoice Lines前端控制器
 *
 * @author ultraman
 * @date 2021-12-24
 */
@RestController
public class ReconciliationInvoiceLinesController {

  @Autowired
  private IReconciliationInvoiceLinesService reconciliationInvoiceLinesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconciliationInvoiceLines 4992 Reconciliation Invoice Lines
   * @return
   */
  @GetMapping("/reconciliationinvoiceliness" )
  public XfR getReconciliationInvoiceLiness(XfPage page, ReconciliationInvoiceLines reconciliationInvoiceLines) {
    return XfR.ok(reconciliationInvoiceLinesServiceImpl.page(page, Wrappers.query(reconciliationInvoiceLines)));
  }

  /**
   * 通过id查询4992 Reconciliation Invoice Lines
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconciliationinvoiceliness/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconciliationInvoiceLinesServiceImpl.getById(id));
  }

  /**
   * 新增4992 Reconciliation Invoice Lines
   * @param reconciliationInvoiceLines 4992 Reconciliation Invoice Lines
   * @return XfR
   */
  @PostMapping("/reconciliationinvoiceliness")
  public XfR save(@RequestBody ReconciliationInvoiceLines reconciliationInvoiceLines) {
     return XfR.ok(reconciliationInvoiceLinesServiceImpl.save(reconciliationInvoiceLines));
  }

  /**
   * 修改-传入修改后的全部数据4992 Reconciliation Invoice Lines
   * @param reconciliationInvoiceLines 4992 Reconciliation Invoice Lines
   * @return XfR
   */
  @PutMapping("/reconciliationinvoiceliness/{id}")
  public XfR putUpdate(@RequestBody ReconciliationInvoiceLines reconciliationInvoiceLines,@PathVariable Long id) {
      reconciliationInvoiceLines.setId(id);
      return XfR.ok(reconciliationInvoiceLinesServiceImpl.updateById(reconciliationInvoiceLines));
  }

  /**
   * 修改-传入修改的数据4992 Reconciliation Invoice Lines
   * @param reconciliationInvoiceLines 4992 Reconciliation Invoice Lines
   * @return XfR
   */
  @PatchMapping("/reconciliationinvoiceliness/{id}")
  public XfR patchUpdate(@RequestBody ReconciliationInvoiceLines reconciliationInvoiceLines,@PathVariable Long id) {
      ReconciliationInvoiceLines upreconciliationInvoiceLines = reconciliationInvoiceLinesServiceImpl.getById(id);
      if(upreconciliationInvoiceLines != null){
        upreconciliationInvoiceLines = ObjectCopyUtils.copyProperties(reconciliationInvoiceLines,upreconciliationInvoiceLines,true);
      }
      return XfR.ok(reconciliationInvoiceLinesServiceImpl.updateById(upreconciliationInvoiceLines));
  }

  /**
   * 通过id删除4992 Reconciliation Invoice Lines
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconciliationinvoiceliness/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconciliationInvoiceLinesServiceImpl.removeById(id));
  }

  @PostMapping("/reconciliationinvoiceliness/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconciliation_invoice_lines");
     params.put("request", condition);

     return XfR.ok(reconciliationInvoiceLinesServiceImpl.querys(params));
  }

}
