package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ImportInfo;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IImportInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-10-28
 */
@RestController
public class ImportInfoController {

  @Autowired
  private IImportInfoService importInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importInfo ${table.comment}
   * @return
   */
  @GetMapping("/importinfos" )
  public XfR getImportInfos(XfPage page, ImportInfo importInfo) {
    return XfR.ok(importInfoServiceImpl.page(page, Wrappers.query(importInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/importinfos")
  public XfR save(@RequestBody ImportInfo importInfo) {
     return XfR.ok(importInfoServiceImpl.save(importInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/importinfos/{id}")
  public XfR putUpdate(@RequestBody ImportInfo importInfo,@PathVariable Long id) {
      importInfo.setId(id);
      return XfR.ok(importInfoServiceImpl.updateById(importInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importinfos/{id}")
  public XfR patchUpdate(@RequestBody ImportInfo importInfo,@PathVariable Long id) {
      ImportInfo upimportInfo = importInfoServiceImpl.getById(id);
      if(upimportInfo != null){
        upimportInfo = ObjectCopyUtils.copyProperties(importInfo,upimportInfo,true);
      }
      return XfR.ok(importInfoServiceImpl.updateById(upimportInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importInfoServiceImpl.removeById(id));
  }

  @PostMapping("/importinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_info");
     params.put("request", condition);

     return XfR.ok(importInfoServiceImpl.querys(params));
  }

}
