package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ImportResultHead;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IImportResultHeadService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 导入结果主信息前端控制器
 *
 * @author ultraman
 * @date 2022-10-28
 */
@RestController
public class ImportResultHeadController {

  @Autowired
  private IImportResultHeadService importResultHeadServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importResultHead 导入结果主信息
   * @return
   */
  @GetMapping("/importresultheads" )
  public XfR getImportResultHeads(XfPage page, ImportResultHead importResultHead) {
    return XfR.ok(importResultHeadServiceImpl.page(page, Wrappers.query(importResultHead)));
  }

  /**
   * 通过id查询导入结果主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/importresultheads/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importResultHeadServiceImpl.getById(id));
  }

  /**
   * 新增导入结果主信息
   * @param importResultHead 导入结果主信息
   * @return XfR
   */
  @PostMapping("/importresultheads")
  public XfR save(@RequestBody ImportResultHead importResultHead) {
     return XfR.ok(importResultHeadServiceImpl.save(importResultHead));
  }

  /**
   * 修改-传入修改后的全部数据导入结果主信息
   * @param importResultHead 导入结果主信息
   * @return XfR
   */
  @PutMapping("/importresultheads/{id}")
  public XfR putUpdate(@RequestBody ImportResultHead importResultHead,@PathVariable Long id) {
      importResultHead.setId(id);
      return XfR.ok(importResultHeadServiceImpl.updateById(importResultHead));
  }

  /**
   * 修改-传入修改的数据导入结果主信息
   * @param importResultHead 导入结果主信息
   * @return XfR
   */
  @PatchMapping("/importresultheads/{id}")
  public XfR patchUpdate(@RequestBody ImportResultHead importResultHead,@PathVariable Long id) {
      ImportResultHead upimportResultHead = importResultHeadServiceImpl.getById(id);
      if(upimportResultHead != null){
        upimportResultHead = ObjectCopyUtils.copyProperties(importResultHead,upimportResultHead,true);
      }
      return XfR.ok(importResultHeadServiceImpl.updateById(upimportResultHead));
  }

  /**
   * 通过id删除导入结果主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importresultheads/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importResultHeadServiceImpl.removeById(id));
  }

  @PostMapping("/importresultheads/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_result_head");
     params.put("request", condition);

     return XfR.ok(importResultHeadServiceImpl.querys(params));
  }

}
