package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.InvoiceSetting;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IInvoiceSettingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票类型匹配配置前端控制器
 *
 * @author ultraman
 * @date 2022-10-28
 */
@RestController
public class InvoiceSettingController {

  @Autowired
  private IInvoiceSettingService invoiceSettingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSetting 发票类型匹配配置
   * @return
   */
  @GetMapping("/invoicesettings" )
  public XfR getInvoiceSettings(XfPage page, InvoiceSetting invoiceSetting) {
    return XfR.ok(invoiceSettingServiceImpl.page(page, Wrappers.query(invoiceSetting)));
  }

  /**
   * 通过id查询发票类型匹配配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicesettings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSettingServiceImpl.getById(id));
  }

  /**
   * 新增发票类型匹配配置
   * @param invoiceSetting 发票类型匹配配置
   * @return XfR
   */
  @PostMapping("/invoicesettings")
  public XfR save(@RequestBody InvoiceSetting invoiceSetting) {
     return XfR.ok(invoiceSettingServiceImpl.save(invoiceSetting));
  }

  /**
   * 修改-传入修改后的全部数据发票类型匹配配置
   * @param invoiceSetting 发票类型匹配配置
   * @return XfR
   */
  @PutMapping("/invoicesettings/{id}")
  public XfR putUpdate(@RequestBody InvoiceSetting invoiceSetting,@PathVariable Long id) {
      invoiceSetting.setId(id);
      return XfR.ok(invoiceSettingServiceImpl.updateById(invoiceSetting));
  }

  /**
   * 修改-传入修改的数据发票类型匹配配置
   * @param invoiceSetting 发票类型匹配配置
   * @return XfR
   */
  @PatchMapping("/invoicesettings/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSetting invoiceSetting,@PathVariable Long id) {
      InvoiceSetting upinvoiceSetting = invoiceSettingServiceImpl.getById(id);
      if(upinvoiceSetting != null){
        upinvoiceSetting = ObjectCopyUtils.copyProperties(invoiceSetting,upinvoiceSetting,true);
      }
      return XfR.ok(invoiceSettingServiceImpl.updateById(upinvoiceSetting));
  }

  /**
   * 通过id删除发票类型匹配配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicesettings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSettingServiceImpl.removeById(id));
  }

  @PostMapping("/invoicesettings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_setting");
     params.put("request", condition);

     return XfR.ok(invoiceSettingServiceImpl.querys(params));
  }

}
