package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ExportPurchase;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IExportPurchaseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 1. export purchase 202105-01 IPS-01(1-313)前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class ExportPurchaseController {

  @Autowired
  private IExportPurchaseService exportPurchaseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exportPurchase 1. export purchase 202105-01 IPS-01(1-313)
   * @return
   */
  @GetMapping("/exportpurchases" )
  public XfR getExportPurchases(XfPage page, ExportPurchase exportPurchase) {
    return XfR.ok(exportPurchaseServiceImpl.page(page, Wrappers.query(exportPurchase)));
  }

  /**
   * 通过id查询1. export purchase 202105-01 IPS-01(1-313)
   * @param  id
   * @return XfR
   */
  @GetMapping("/exportpurchases/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exportPurchaseServiceImpl.getById(id));
  }

  /**
   * 新增1. export purchase 202105-01 IPS-01(1-313)
   * @param exportPurchase 1. export purchase 202105-01 IPS-01(1-313)
   * @return XfR
   */
  @PostMapping("/exportpurchases")
  public XfR save(@RequestBody ExportPurchase exportPurchase) {
     return XfR.ok(exportPurchaseServiceImpl.save(exportPurchase));
  }

  /**
   * 修改-传入修改后的全部数据1. export purchase 202105-01 IPS-01(1-313)
   * @param exportPurchase 1. export purchase 202105-01 IPS-01(1-313)
   * @return XfR
   */
  @PutMapping("/exportpurchases/{id}")
  public XfR putUpdate(@RequestBody ExportPurchase exportPurchase,@PathVariable Long id) {
      exportPurchase.setId(id);
      return XfR.ok(exportPurchaseServiceImpl.updateById(exportPurchase));
  }

  /**
   * 修改-传入修改的数据1. export purchase 202105-01 IPS-01(1-313)
   * @param exportPurchase 1. export purchase 202105-01 IPS-01(1-313)
   * @return XfR
   */
  @PatchMapping("/exportpurchases/{id}")
  public XfR patchUpdate(@RequestBody ExportPurchase exportPurchase,@PathVariable Long id) {
      ExportPurchase upexportPurchase = exportPurchaseServiceImpl.getById(id);
      if(upexportPurchase != null){
        upexportPurchase = ObjectCopyUtils.copyProperties(exportPurchase,upexportPurchase,true);
      }
      return XfR.ok(exportPurchaseServiceImpl.updateById(upexportPurchase));
  }

  /**
   * 通过id删除1. export purchase 202105-01 IPS-01(1-313)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exportpurchases/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exportPurchaseServiceImpl.removeById(id));
  }

  @PostMapping("/exportpurchases/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "export_purchase");
     params.put("request", condition);

     return XfR.ok(exportPurchaseServiceImpl.querys(params));
  }

}
