package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ImportResultDetail;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IImportResultDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 导入结果明细信息前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class ImportResultDetailController {

  @Autowired
  private IImportResultDetailService importResultDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importResultDetail 导入结果明细信息
   * @return
   */
  @GetMapping("/importresultdetails" )
  public XfR getImportResultDetails(XfPage page, ImportResultDetail importResultDetail) {
    return XfR.ok(importResultDetailServiceImpl.page(page, Wrappers.query(importResultDetail)));
  }

  /**
   * 通过id查询导入结果明细信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/importresultdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importResultDetailServiceImpl.getById(id));
  }

  /**
   * 新增导入结果明细信息
   * @param importResultDetail 导入结果明细信息
   * @return XfR
   */
  @PostMapping("/importresultdetails")
  public XfR save(@RequestBody ImportResultDetail importResultDetail) {
     return XfR.ok(importResultDetailServiceImpl.save(importResultDetail));
  }

  /**
   * 修改-传入修改后的全部数据导入结果明细信息
   * @param importResultDetail 导入结果明细信息
   * @return XfR
   */
  @PutMapping("/importresultdetails/{id}")
  public XfR putUpdate(@RequestBody ImportResultDetail importResultDetail,@PathVariable Long id) {
      importResultDetail.setId(id);
      return XfR.ok(importResultDetailServiceImpl.updateById(importResultDetail));
  }

  /**
   * 修改-传入修改的数据导入结果明细信息
   * @param importResultDetail 导入结果明细信息
   * @return XfR
   */
  @PatchMapping("/importresultdetails/{id}")
  public XfR patchUpdate(@RequestBody ImportResultDetail importResultDetail,@PathVariable Long id) {
      ImportResultDetail upimportResultDetail = importResultDetailServiceImpl.getById(id);
      if(upimportResultDetail != null){
        upimportResultDetail = ObjectCopyUtils.copyProperties(importResultDetail,upimportResultDetail,true);
      }
      return XfR.ok(importResultDetailServiceImpl.updateById(upimportResultDetail));
  }

  /**
   * 通过id删除导入结果明细信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importresultdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importResultDetailServiceImpl.removeById(id));
  }

  @PostMapping("/importresultdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_result_detail");
     params.put("request", condition);

     return XfR.ok(importResultDetailServiceImpl.querys(params));
  }

}
