package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.ReconciliationInvoiceLines7700;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IReconciliationInvoiceLines7700Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 7700 Reconciliation Invoice Lines 前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class ReconciliationInvoiceLines7700Controller {

  @Autowired
  private IReconciliationInvoiceLines7700Service reconciliationInvoiceLines7700ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconciliationInvoiceLines7700 7700 Reconciliation Invoice Lines 
   * @return
   */
  @GetMapping("/reconciliationinvoicelines7700s" )
  public XfR getReconciliationInvoiceLines7700s(XfPage page, ReconciliationInvoiceLines7700 reconciliationInvoiceLines7700) {
    return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.page(page, Wrappers.query(reconciliationInvoiceLines7700)));
  }

  /**
   * 通过id查询7700 Reconciliation Invoice Lines 
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconciliationinvoicelines7700s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.getById(id));
  }

  /**
   * 新增7700 Reconciliation Invoice Lines 
   * @param reconciliationInvoiceLines7700 7700 Reconciliation Invoice Lines 
   * @return XfR
   */
  @PostMapping("/reconciliationinvoicelines7700s")
  public XfR save(@RequestBody ReconciliationInvoiceLines7700 reconciliationInvoiceLines7700) {
     return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.save(reconciliationInvoiceLines7700));
  }

  /**
   * 修改-传入修改后的全部数据7700 Reconciliation Invoice Lines 
   * @param reconciliationInvoiceLines7700 7700 Reconciliation Invoice Lines 
   * @return XfR
   */
  @PutMapping("/reconciliationinvoicelines7700s/{id}")
  public XfR putUpdate(@RequestBody ReconciliationInvoiceLines7700 reconciliationInvoiceLines7700,@PathVariable Long id) {
      reconciliationInvoiceLines7700.setId(id);
      return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.updateById(reconciliationInvoiceLines7700));
  }

  /**
   * 修改-传入修改的数据7700 Reconciliation Invoice Lines 
   * @param reconciliationInvoiceLines7700 7700 Reconciliation Invoice Lines 
   * @return XfR
   */
  @PatchMapping("/reconciliationinvoicelines7700s/{id}")
  public XfR patchUpdate(@RequestBody ReconciliationInvoiceLines7700 reconciliationInvoiceLines7700,@PathVariable Long id) {
      ReconciliationInvoiceLines7700 upreconciliationInvoiceLines7700 = reconciliationInvoiceLines7700ServiceImpl.getById(id);
      if(upreconciliationInvoiceLines7700 != null){
        upreconciliationInvoiceLines7700 = ObjectCopyUtils.copyProperties(reconciliationInvoiceLines7700,upreconciliationInvoiceLines7700,true);
      }
      return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.updateById(upreconciliationInvoiceLines7700));
  }

  /**
   * 通过id删除7700 Reconciliation Invoice Lines 
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconciliationinvoicelines7700s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.removeById(id));
  }

  @PostMapping("/reconciliationinvoicelines7700s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconciliation_invoice_lines7700");
     params.put("request", condition);

     return XfR.ok(reconciliationInvoiceLines7700ServiceImpl.querys(params));
  }

}
