package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.TaxRemark;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.ITaxRemarkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class TaxRemarkController {

  @Autowired
  private ITaxRemarkService taxRemarkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxRemark ${table.comment}
   * @return
   */
  @GetMapping("/taxremarks" )
  public XfR getTaxRemarks(XfPage page, TaxRemark taxRemark) {
    return XfR.ok(taxRemarkServiceImpl.page(page, Wrappers.query(taxRemark)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxremarks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxRemarkServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxRemark ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxremarks")
  public XfR save(@RequestBody TaxRemark taxRemark) {
     return XfR.ok(taxRemarkServiceImpl.save(taxRemark));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxRemark ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxremarks/{id}")
  public XfR putUpdate(@RequestBody TaxRemark taxRemark,@PathVariable Long id) {
      taxRemark.setId(id);
      return XfR.ok(taxRemarkServiceImpl.updateById(taxRemark));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxRemark ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxremarks/{id}")
  public XfR patchUpdate(@RequestBody TaxRemark taxRemark,@PathVariable Long id) {
      TaxRemark uptaxRemark = taxRemarkServiceImpl.getById(id);
      if(uptaxRemark != null){
        uptaxRemark = ObjectCopyUtils.copyProperties(taxRemark,uptaxRemark,true);
      }
      return XfR.ok(taxRemarkServiceImpl.updateById(uptaxRemark));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxremarks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxRemarkServiceImpl.removeById(id));
  }

  @PostMapping("/taxremarks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_remark");
     params.put("request", condition);

     return XfR.ok(taxRemarkServiceImpl.querys(params));
  }

}
