package com.xforceplus.ultraman.app.jcinvoiceikea.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcinvoiceikea.entity.UploadFileToOss;
import com.xforceplus.ultraman.app.jcinvoiceikea.service.IUploadFileToOssService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 上传OSS的电票源文件信息前端控制器
 *
 * @author ultraman
 * @date 2022-11-07
 */
@RestController
public class UploadFileToOssController {

  @Autowired
  private IUploadFileToOssService uploadFileToOssServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return
   */
  @GetMapping("/uploadfiletoosss" )
  public XfR getUploadFileToOsss(XfPage page, UploadFileToOss uploadFileToOss) {
    return XfR.ok(uploadFileToOssServiceImpl.page(page, Wrappers.query(uploadFileToOss)));
  }

  /**
   * 通过id查询上传OSS的电票源文件信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/uploadfiletoosss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(uploadFileToOssServiceImpl.getById(id));
  }

  /**
   * 新增上传OSS的电票源文件信息
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return XfR
   */
  @PostMapping("/uploadfiletoosss")
  public XfR save(@RequestBody UploadFileToOss uploadFileToOss) {
     return XfR.ok(uploadFileToOssServiceImpl.save(uploadFileToOss));
  }

  /**
   * 修改-传入修改后的全部数据上传OSS的电票源文件信息
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return XfR
   */
  @PutMapping("/uploadfiletoosss/{id}")
  public XfR putUpdate(@RequestBody UploadFileToOss uploadFileToOss,@PathVariable Long id) {
      uploadFileToOss.setId(id);
      return XfR.ok(uploadFileToOssServiceImpl.updateById(uploadFileToOss));
  }

  /**
   * 修改-传入修改的数据上传OSS的电票源文件信息
   * @param uploadFileToOss 上传OSS的电票源文件信息
   * @return XfR
   */
  @PatchMapping("/uploadfiletoosss/{id}")
  public XfR patchUpdate(@RequestBody UploadFileToOss uploadFileToOss,@PathVariable Long id) {
      UploadFileToOss upuploadFileToOss = uploadFileToOssServiceImpl.getById(id);
      if(upuploadFileToOss != null){
        upuploadFileToOss = ObjectCopyUtils.copyProperties(uploadFileToOss,upuploadFileToOss,true);
      }
      return XfR.ok(uploadFileToOssServiceImpl.updateById(upuploadFileToOss));
  }

  /**
   * 通过id删除上传OSS的电票源文件信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/uploadfiletoosss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(uploadFileToOssServiceImpl.removeById(id));
  }

  @PostMapping("/uploadfiletoosss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "upload_file_to_oss");
     params.put("request", condition);

     return XfR.ok(uploadFileToOssServiceImpl.querys(params));
  }

}
