package com.xforceplus.ultraman.app.jckaide.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_metadata
 * </p>
 *
 * @author ultraman
 * @since 2024-08-12
 */
public enum IsMetadata {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsMetadata(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsMetadata fromCode(String code) {
        return Stream.of(IsMetadata.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
