package com.xforceplus.ultraman.app.jckaide.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * open_switch
 * </p>
 *
 * @author ultraman
 * @since 2024-08-12
 */
public enum OpenSwitch {

    _0("0", "禁用"),
    _1("1", "启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OpenSwitch(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OpenSwitch fromCode(String code) {
        return Stream.of(OpenSwitch.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
