package com.xforceplus.ultraman.app.jcksp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * config_item
 * </p>
 *
 * @author ultraman
 * @since 2024-07-03
 */
public enum ConfigItem {

    _0("0", "apollo配置变更"),
    _1("1", "数据库变更"),
    _2("2", "ES配置变更");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConfigItem(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfigItem fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
