package com.xforceplus.ultraman.app.jcksp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * deploy_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-03
 */
public enum DeployStatus {

    _0("0", "未部署"),
    _1("1", "部署成功"),
    _2("2", "部署失败"),
    _3("3", "部署中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DeployStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DeployStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
