package com.xforceplus.ultraman.app.jcksp.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * env
 * </p>
 *
 * @author ultraman
 * @since 2024-07-03
 */
public enum Env {

    SIT("sit", "sit"),
    PROD("prod", "prod");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Env(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Env fromCode(String code){
        switch(code) {
            case "sit":
                return SIT;
            case "prod":
                return PROD;
            default:
                return null;
        }
    }
}
