package com.xforceplus.ultraman.app.jcksp.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-07-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DeploymentService implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 命名空间
   */
  private String namespace;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 服务版本Id
   */
  private Long serviceVersionId;

  /**
   * 服务名称
   */
  private String serviceName;

  /**
   * chart版本
   */
  private String chartVersion;

  /**
   * 奥特曼项目版本
   */
  private String ultramanAppVersion;

  /**
   * 集群
   */
  private String cluster;

  /**
   * 部署状态
   */
  private String deployStatus;

  /**
   * 部署任务id
   */
  private String deployTaskId;

  /**
   * 部署失败原因
   */
  private String deployRemark;

  /**
   * 部署批次号
   */
  private Long batchNo;


  /**
   * 对一关联关系 关联对象 deployment
   */
    private Long deployAndServiceId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("namespace", namespace);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("service_version_id", serviceVersionId);
      map.put("service_name", serviceName);
      map.put("chart_version", chartVersion);
      map.put("ultraman_app_version", ultramanAppVersion);
      map.put("cluster", cluster);
      map.put("deploy_status", deployStatus);
      map.put("deploy_task_id", deployTaskId);
      map.put("deploy_remark", deployRemark);
      map.put("batch_no", batchNo);

       map.put("deployAndService.id", deployAndServiceId);
      return map;
  }

  public static DeploymentService fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DeploymentService entity = new DeploymentService();
    if(map.containsKey("namespace")) {
      Object obj = map.get("namespace");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNamespace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_version_id")) {
      Object obj = map.get("service_version_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceVersionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceVersionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setServiceVersionId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chart_version")) {
      Object obj = map.get("chart_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChartVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ultraman_app_version")) {
      Object obj = map.get("ultraman_app_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUltramanAppVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cluster")) {
      Object obj = map.get("cluster");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCluster((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deploy_status")) {
      Object obj = map.get("deploy_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deploy_task_id")) {
      Object obj = map.get("deploy_task_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deploy_remark")) {
      Object obj = map.get("deploy_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("deployAndService.id")) {
        Object obj = map.get("deployAndService.id");
      if(obj instanceof Long) {
        entity.setDeployAndServiceId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setDeployAndServiceId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("namespace")) {
      Object obj = map.get("namespace");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNamespace((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("service_version_id")) {
      Object obj = map.get("service_version_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setServiceVersionId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceVersionId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setServiceVersionId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("service_name")) {
      Object obj = map.get("service_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chart_version")) {
      Object obj = map.get("chart_version");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChartVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ultraman_app_version")) {
      Object obj = map.get("ultraman_app_version");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUltramanAppVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cluster")) {
      Object obj = map.get("cluster");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCluster((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deploy_status")) {
      Object obj = map.get("deploy_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deploy_task_id")) {
      Object obj = map.get("deploy_task_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployTaskId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deploy_remark")) {
      Object obj = map.get("deploy_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBatchNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBatchNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBatchNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
      if(map.containsKey("deployAndService.id")) {
        Object obj = map.get("deployAndService.id");
        if(obj instanceof Long) {
          this.setDeployAndServiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeployAndServiceId(Long.parseLong((String)obj));
        }
      }
  }
}
