package com.xforceplus.ultraman.app.jclikai.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum InvoiceKind1683539265247 {

    C("c", "增值税普通发票"),
    S("s", "增值税专用发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票"),
    CT("ct", "通行费发票"),
    JU("ju", "增值税普通发票（卷票）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceKind1683539265247(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceKind1683539265247 fromCode(String code) {
        return Stream.of(InvoiceKind1683539265247.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
