package com.xforceplus.ultraman.app.jclikai.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红冲状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public enum ReverseStatus {

    _0("0", "正常"),
    _3("3", "已完成红冲"),
    _4("4", "已部分红冲");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReverseStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReverseStatus fromCode(String code) {
        return Stream.of(ReverseStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
