package com.xforceplus.ultraman.app.jclikai.metadata.validator;

import com.xforceplus.ultraman.app.jclikai.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jclikai.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AccountType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReverseStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReverseStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReverseStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStyleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStyleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStyleType.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(DataSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataSource.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStyle.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaymentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TurnOutType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AgentIssuedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AgentIssuedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AgentIssuedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceKind1683539265247.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceKind1683539265247.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceKind1683539265247.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(GenerateModel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GenerateModel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GenerateModel.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CoverRule.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CoverRule.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CoverRule.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ImportInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImportInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImportInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryServiceReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryServiceReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryServiceReason.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailDirection.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryDetailDirection.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryDetailDirection.class.getSimpleName());
            }
        }
        if(clazz.equals(InventoryDetailType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InventoryDetailType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InventoryDetailType.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
