package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.Clazz;
import com.xforceplus.ultraman.app.jclikai.service.IClazzService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class ClazzController {

  @Autowired
  private IClazzService clazzServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param clazz ${table.comment}
   * @return
   */
  @GetMapping("/clazzs" )
  public XfR getClazzs(XfPage page, Clazz clazz) {
    return XfR.ok(clazzServiceImpl.page(page, Wrappers.query(clazz)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/clazzs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(clazzServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param clazz ${table.comment}
   * @return XfR
   */
  @PostMapping("/clazzs")
  public XfR save(@RequestBody Clazz clazz) {
     return XfR.ok(clazzServiceImpl.save(clazz));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param clazz ${table.comment}
   * @return XfR
   */
  @PutMapping("/clazzs/{id}")
  public XfR putUpdate(@RequestBody Clazz clazz,@PathVariable Long id) {
      clazz.setId(id);
      return XfR.ok(clazzServiceImpl.updateById(clazz));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param clazz ${table.comment}
   * @return XfR
   */
  @PatchMapping("/clazzs/{id}")
  public XfR patchUpdate(@RequestBody Clazz clazz,@PathVariable Long id) {
      Clazz upclazz = clazzServiceImpl.getById(id);
      if(upclazz != null){
        upclazz = ObjectCopyUtils.copyProperties(clazz,upclazz,true);
      }
      return XfR.ok(clazzServiceImpl.updateById(upclazz));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/clazzs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(clazzServiceImpl.removeById(id));
  }

  @PostMapping("/clazzs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "clazz");
     params.put("request", condition);

     return XfR.ok(clazzServiceImpl.querys(params));
  }

}
