package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.FilterSalesInvoiceItem;
import com.xforceplus.ultraman.app.jclikai.service.IFilterSalesInvoiceItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class FilterSalesInvoiceItemController {

  @Autowired
  private IFilterSalesInvoiceItemService filterSalesInvoiceItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param filterSalesInvoiceItem ${table.comment}
   * @return
   */
  @GetMapping("/filtersalesinvoiceitems" )
  public XfR getFilterSalesInvoiceItems(XfPage page, FilterSalesInvoiceItem filterSalesInvoiceItem) {
    return XfR.ok(filterSalesInvoiceItemServiceImpl.page(page, Wrappers.query(filterSalesInvoiceItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/filtersalesinvoiceitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(filterSalesInvoiceItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param filterSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/filtersalesinvoiceitems")
  public XfR save(@RequestBody FilterSalesInvoiceItem filterSalesInvoiceItem) {
     return XfR.ok(filterSalesInvoiceItemServiceImpl.save(filterSalesInvoiceItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param filterSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/filtersalesinvoiceitems/{id}")
  public XfR putUpdate(@RequestBody FilterSalesInvoiceItem filterSalesInvoiceItem,@PathVariable Long id) {
      filterSalesInvoiceItem.setId(id);
      return XfR.ok(filterSalesInvoiceItemServiceImpl.updateById(filterSalesInvoiceItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param filterSalesInvoiceItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/filtersalesinvoiceitems/{id}")
  public XfR patchUpdate(@RequestBody FilterSalesInvoiceItem filterSalesInvoiceItem,@PathVariable Long id) {
      FilterSalesInvoiceItem upfilterSalesInvoiceItem = filterSalesInvoiceItemServiceImpl.getById(id);
      if(upfilterSalesInvoiceItem != null){
        upfilterSalesInvoiceItem = ObjectCopyUtils.copyProperties(filterSalesInvoiceItem,upfilterSalesInvoiceItem,true);
      }
      return XfR.ok(filterSalesInvoiceItemServiceImpl.updateById(upfilterSalesInvoiceItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filtersalesinvoiceitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(filterSalesInvoiceItemServiceImpl.removeById(id));
  }

  @PostMapping("/filtersalesinvoiceitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "filter_sales_invoice_item");
     params.put("request", condition);

     return XfR.ok(filterSalesInvoiceItemServiceImpl.querys(params));
  }

}
