package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.GoodsInfo01;
import com.xforceplus.ultraman.app.jclikai.service.IGoodsInfo01Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class GoodsInfo01Controller {

  @Autowired
  private IGoodsInfo01Service goodsInfo01ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsInfo01 ${table.comment}
   * @return
   */
  @GetMapping("/goodsinfo01s" )
  public XfR getGoodsInfo01s(XfPage page, GoodsInfo01 goodsInfo01) {
    return XfR.ok(goodsInfo01ServiceImpl.page(page, Wrappers.query(goodsInfo01)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsinfo01s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsInfo01ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsInfo01 ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsinfo01s")
  public XfR save(@RequestBody GoodsInfo01 goodsInfo01) {
     return XfR.ok(goodsInfo01ServiceImpl.save(goodsInfo01));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsInfo01 ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsinfo01s/{id}")
  public XfR putUpdate(@RequestBody GoodsInfo01 goodsInfo01,@PathVariable Long id) {
      goodsInfo01.setId(id);
      return XfR.ok(goodsInfo01ServiceImpl.updateById(goodsInfo01));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsInfo01 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsinfo01s/{id}")
  public XfR patchUpdate(@RequestBody GoodsInfo01 goodsInfo01,@PathVariable Long id) {
      GoodsInfo01 upgoodsInfo01 = goodsInfo01ServiceImpl.getById(id);
      if(upgoodsInfo01 != null){
        upgoodsInfo01 = ObjectCopyUtils.copyProperties(goodsInfo01,upgoodsInfo01,true);
      }
      return XfR.ok(goodsInfo01ServiceImpl.updateById(upgoodsInfo01));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsinfo01s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsInfo01ServiceImpl.removeById(id));
  }

  @PostMapping("/goodsinfo01s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_info01");
     params.put("request", condition);

     return XfR.ok(goodsInfo01ServiceImpl.querys(params));
  }

}
