package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.Qilixiang;
import com.xforceplus.ultraman.app.jclikai.service.IQilixiangService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class QilixiangController {

  @Autowired
  private IQilixiangService qilixiangServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param qilixiang ${table.comment}
   * @return
   */
  @GetMapping("/qilixiangs" )
  public XfR getQilixiangs(XfPage page, Qilixiang qilixiang) {
    return XfR.ok(qilixiangServiceImpl.page(page, Wrappers.query(qilixiang)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/qilixiangs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(qilixiangServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param qilixiang ${table.comment}
   * @return XfR
   */
  @PostMapping("/qilixiangs")
  public XfR save(@RequestBody Qilixiang qilixiang) {
     return XfR.ok(qilixiangServiceImpl.save(qilixiang));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param qilixiang ${table.comment}
   * @return XfR
   */
  @PutMapping("/qilixiangs/{id}")
  public XfR putUpdate(@RequestBody Qilixiang qilixiang,@PathVariable Long id) {
      qilixiang.setId(id);
      return XfR.ok(qilixiangServiceImpl.updateById(qilixiang));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param qilixiang ${table.comment}
   * @return XfR
   */
  @PatchMapping("/qilixiangs/{id}")
  public XfR patchUpdate(@RequestBody Qilixiang qilixiang,@PathVariable Long id) {
      Qilixiang upqilixiang = qilixiangServiceImpl.getById(id);
      if(upqilixiang != null){
        upqilixiang = ObjectCopyUtils.copyProperties(qilixiang,upqilixiang,true);
      }
      return XfR.ok(qilixiangServiceImpl.updateById(upqilixiang));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/qilixiangs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(qilixiangServiceImpl.removeById(id));
  }

  @PostMapping("/qilixiangs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "qilixiang");
     params.put("request", condition);

     return XfR.ok(qilixiangServiceImpl.querys(params));
  }

}
