package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.School;
import com.xforceplus.ultraman.app.jclikai.service.ISchoolService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class SchoolController {

  @Autowired
  private ISchoolService schoolServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param school ${table.comment}
   * @return
   */
  @GetMapping("/schools" )
  public XfR getSchools(XfPage page, School school) {
    return XfR.ok(schoolServiceImpl.page(page, Wrappers.query(school)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/schools/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(schoolServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param school ${table.comment}
   * @return XfR
   */
  @PostMapping("/schools")
  public XfR save(@RequestBody School school) {
     return XfR.ok(schoolServiceImpl.save(school));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param school ${table.comment}
   * @return XfR
   */
  @PutMapping("/schools/{id}")
  public XfR putUpdate(@RequestBody School school,@PathVariable Long id) {
      school.setId(id);
      return XfR.ok(schoolServiceImpl.updateById(school));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param school ${table.comment}
   * @return XfR
   */
  @PatchMapping("/schools/{id}")
  public XfR patchUpdate(@RequestBody School school,@PathVariable Long id) {
      School upschool = schoolServiceImpl.getById(id);
      if(upschool != null){
        upschool = ObjectCopyUtils.copyProperties(school,upschool,true);
      }
      return XfR.ok(schoolServiceImpl.updateById(upschool));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/schools/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(schoolServiceImpl.removeById(id));
  }

  @PostMapping("/schools/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "school");
     params.put("request", condition);

     return XfR.ok(schoolServiceImpl.querys(params));
  }

}
