package com.xforceplus.ultraman.app.jclikai.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jclikai.entity.Student;
import com.xforceplus.ultraman.app.jclikai.service.IStudentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class StudentController {

  @Autowired
  private IStudentService studentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param student ${table.comment}
   * @return
   */
  @GetMapping("/students" )
  public XfR getStudents(XfPage page, Student student) {
    return XfR.ok(studentServiceImpl.page(page, Wrappers.query(student)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/students/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(studentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param student ${table.comment}
   * @return XfR
   */
  @PostMapping("/students")
  public XfR save(@RequestBody Student student) {
     return XfR.ok(studentServiceImpl.save(student));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param student ${table.comment}
   * @return XfR
   */
  @PutMapping("/students/{id}")
  public XfR putUpdate(@RequestBody Student student,@PathVariable Long id) {
      student.setId(id);
      return XfR.ok(studentServiceImpl.updateById(student));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param student ${table.comment}
   * @return XfR
   */
  @PatchMapping("/students/{id}")
  public XfR patchUpdate(@RequestBody Student student,@PathVariable Long id) {
      Student upstudent = studentServiceImpl.getById(id);
      if(upstudent != null){
        upstudent = ObjectCopyUtils.copyProperties(student,upstudent,true);
      }
      return XfR.ok(studentServiceImpl.updateById(upstudent));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/students/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(studentServiceImpl.removeById(id));
  }

  @PostMapping("/students/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "student");
     params.put("request", condition);

     return XfR.ok(studentServiceImpl.querys(params));
  }

}
