package com.xforceplus.ultraman.app.jclusilong.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-06-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderItem implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购单号
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 采购单行号
   */
  private Long item;

  /**
   * 物料号
   */
  @TableField("materialServiceNo")
  private String materialServiceNo;

  /**
   * WBS
   */
  private String wbs;

  /**
   * 无聊名称
   */
  @TableField("materialServiceName")
  private String materialServiceName;

  /**
   * 币种
   */
  private String currency;

  /**
   * 合同号
   */
  @TableField("contractID")
  private String contractID;

  /**
   * 税码
   */
  @TableField("vatCode")
  private String vatCode;

  /**
   * 物料组
   */
  @TableField("materialServiceOrg")
  private String materialServiceOrg;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 purchaseOrder
   */
    private Long purchaseOrderItemRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("poNumber", poNumber);
      map.put("item", item);
      map.put("materialServiceNo", materialServiceNo);
      map.put("wbs", wbs);
      map.put("materialServiceName", materialServiceName);
      map.put("currency", currency);
      map.put("contractID", contractID);
      map.put("vatCode", vatCode);
      map.put("materialServiceOrg", materialServiceOrg);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("purchaseOrderItemRelation.id", purchaseOrderItemRelationId);
      return map;
  }

  public static PurchaseOrderItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderItem entity = new PurchaseOrderItem();
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItem(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("materialServiceNo")) {
      Object obj = map.get("materialServiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWbs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServiceName")) {
      Object obj = map.get("materialServiceName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServiceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialServiceOrg")) {
      Object obj = map.get("materialServiceOrg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialServiceOrg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("purchaseOrderItemRelation.id")) {
        Object obj = map.get("purchaseOrderItemRelation.id");
      if(obj instanceof Long) {
        entity.setPurchaseOrderItemRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItem((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItem(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItem(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("materialServiceNo")) {
      Object obj = map.get("materialServiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialServiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wbs")) {
      Object obj = map.get("wbs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWbs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialServiceName")) {
      Object obj = map.get("materialServiceName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialServiceName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractID")) {
      Object obj = map.get("contractID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatCode")) {
      Object obj = map.get("vatCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVatCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialServiceOrg")) {
      Object obj = map.get("materialServiceOrg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialServiceOrg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("purchaseOrderItemRelation.id")) {
        Object obj = map.get("purchaseOrderItemRelation.id");
        if(obj instanceof Long) {
          this.setPurchaseOrderItemRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseOrderItemRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
