package com.xforceplus.ultraman.app.jcmars.controller;


/**
 * 单据明细feign客户端
 *
 * @author ultraman
 * @date 2022-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmars.entity.Billing;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mars")
public interface BillingFeignApi {

  /**
   * 通过id查询单据明细
   * @param  id
   * @return R
   */
  @GetMapping("/billing/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增单据明细
   * @param billing 单据明细
   * @return R
   */
  @PostMapping("/billing/add")
  public R save(@RequestBody Billing billing);

  /**
   * 修改单据明细
   * @param billing 单据明细
   * @return R
   */
  @PostMapping("/billing/update")
  public R updateById(@RequestBody Billing billing);

  /**
   * 通过id删除单据明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/billing/del/{id}" )
  public R removeById(@PathVariable Long id);

}