package com.xforceplus.ultraman.app.jcmars.controller;


/**
 * 单据头feign客户端
 *
 * @author ultraman
 * @date 2022-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmars.entity.BillingHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mars")
public interface BillingHeadFeignApi {

  /**
   * 通过id查询单据头
   * @param  id
   * @return R
   */
  @GetMapping("/billingHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增单据头
   * @param billingHead 单据头
   * @return R
   */
  @PostMapping("/billingHead/add")
  public R save(@RequestBody BillingHead billingHead);

  /**
   * 修改单据头
   * @param billingHead 单据头
   * @return R
   */
  @PostMapping("/billingHead/update")
  public R updateById(@RequestBody BillingHead billingHead);

  /**
   * 通过id删除单据头
   * @param  id
   * @return R
   */
  @DeleteMapping("/billingHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}