package com.xforceplus.ultraman.app.jcmars.controller;


/**
 * 预制发票明细feign客户端
 *
 * @author ultraman
 * @date 2022-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmars.entity.PreInvoiceItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mars")
public interface PreInvoiceItemFeignApi {

  /**
   * 通过id查询预制发票明细
   * @param  id
   * @return R
   */
  @GetMapping("/preInvoiceItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增预制发票明细
   * @param preInvoiceItem 预制发票明细
   * @return R
   */
  @PostMapping("/preInvoiceItem/add")
  public R save(@RequestBody PreInvoiceItem preInvoiceItem);

  /**
   * 修改预制发票明细
   * @param preInvoiceItem 预制发票明细
   * @return R
   */
  @PostMapping("/preInvoiceItem/update")
  public R updateById(@RequestBody PreInvoiceItem preInvoiceItem);

  /**
   * 通过id删除预制发票明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/preInvoiceItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}